/*
 * Decompiled with CFR 0.152.
 */
package com.android.files.domain.util;

import com.android.files.domain.util.AndroidFilesHandler;
import com.dto.LoginDto;
import com.utility.ConvertStr;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import org.springframework.util.FileSystemUtils;
import org.springframework.web.multipart.MultipartFile;

public class AndroidFilesHandler {
    private final LoginDto loginDto;
    private final PictureType type;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File saveFile(MultipartFile file) {
        if (ConvertStr.isNullOrEmpty((String)file.getOriginalFilename())) {
            throw new RuntimeException("Failed to store file.");
        }
        File createdFile = this.makeFileAndFolders(file.getOriginalFilename());
        try (InputStream inputStream = file.getInputStream();){
            assert (createdFile != null);
            Files.copy(inputStream, createdFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            File file2 = createdFile;
            return file2;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to store file.");
        }
    }

    private File makeFileAndFolders(String fileName) {
        try {
            return this.createFile(fileName);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void deleteUnusedFiles(List<String> usedFileNamesList) throws IOException {
        Files.walkFileTree(Paths.get(this.getPicturesDirectory(), new String[0]), (FileVisitor<? super Path>)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void deleteDirIfEmpty(Path dir) {
        File dirFile = dir.toFile();
        String[] children = dirFile.list();
        if (children != null && children.length == 0) {
            FileSystemUtils.deleteRecursively((File)dirFile);
        }
    }

    private File createFile(String fileName) throws IOException {
        File file = new File(this.getDirectory(), this.checkFileName(fileName));
        file.mkdirs();
        file.createNewFile();
        return file;
    }

    private String getPicturesDirectory() {
        return "." + File.separator + "pictures";
    }

    private String getDirectory() {
        return this.getPicturesDirectory() + File.separator + this.loginDto.getSerial() + "-" + this.loginDto.getDatabaseName() + File.separator + this.type.name();
    }

    private String checkFileName(String fileName) {
        return ConvertStr.isNullOrEmpty((String)fileName) ? "" : fileName;
    }

    public AndroidFilesHandler(LoginDto loginDto, PictureType type) {
        this.loginDto = loginDto;
        this.type = type;
    }

    static /* synthetic */ void access$000(AndroidFilesHandler x0, Path x1) {
        x0.deleteDirIfEmpty(x1);
    }
}

